<?php

/**
 * Broadcasting configuration options.
 *
 * Changes to these config files are not supported by BookStack and may break upon updates.
 * Configuration should be altered via the `.env` file or environment variables.
 * Do not edit this file unless you're happy to maintain any changes yourself.
 */

return [

    // Default Broadcaster
    // This option controls the default broadcaster that will be used by the
    // framework when an event needs to be broadcast. This can be set to
    // any of the connections defined in the "connections" array below.
    'default' => 'null',

    // Broadcast Connections
    // Here you may define all of the broadcast connections that will be used
    // to broadcast events to other systems or over websockets. Samples of
    // each available type of connection are provided inside this array.
    'connections' => [

        // Default options removed since we don't use broadcasting.

        'log' => [
            'driver' => 'log',
        ],

        'null' => [
            'driver' => 'null',
        ],

    ],

];
