<a href="<?php echo e($shelf->getUrl()); ?>" class="shelf entity-list-item" data-entity-type="bookshelf" data-entity-id="<?php echo e($shelf->id); ?>">
    <div class="entity-list-item-image bg-bookshelf <?php if($shelf->image_id): ?> has-image <?php endif; ?>" style="background-image: url('<?php echo e($shelf->getBookCover()); ?>')">
        <?php echo (new \BookStack\Util\SvgIcon('bookshelf'))->toHtml(); ?>
    </div>
    <div class="content py-xs">
        <h4 class="entity-list-item-name break-text"><?php echo e($shelf->name); ?></h4>
        <div class="entity-item-snippet">
            <p class="text-muted break-text mb-none"><?php echo e($shelf->getExcerpt()); ?></p>
        </div>
    </div>
</a>
<div class="entity-shelf-books grid third gap-y-xs entity-list-item-children">
    <?php $__currentLoopData = $shelf->visibleBooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div>
            <a href="<?php echo e($book->getUrl('?shelf=' . $shelf->id)); ?>" class="entity-chip text-book">
                <?php echo (new \BookStack\Util\SvgIcon('book'))->toHtml(); ?>
                <?php echo e($book->name); ?>

            </a>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div><?php /**PATH /var/www/sacredwits.com/resources/views/shelves/parts/list-item.blade.php ENDPATH**/ ?>