<div class="flex-container-row items-center gap-m">
    <span class="api-method text-mono" data-method="<?php echo e($endpoint['method']); ?>"><?php echo e($endpoint['method']); ?></span>
    <h5 id="<?php echo e($endpoint['name']); ?>" class="text-mono pb-xs">
        <?php if($endpoint['controller_method_kebab'] === 'list'): ?>
            <a style="color: inherit;" target="_blank" rel="noopener" href="<?php echo e(url($endpoint['uri'])); ?>"><?php echo e(url($endpoint['uri'])); ?></a>
        <?php else: ?>
            <span><?php echo e(url($endpoint['uri'])); ?></span>
        <?php endif; ?>
    </h5>
    <h6 class="text-uppercase text-muted text-mono ml-auto"><?php echo e($endpoint['controller_method_kebab']); ?></h6>
</div>

<div class="mb-m">
    <?php $__currentLoopData = explode("\n", $endpoint['description'] ?? ''); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $descriptionBlock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <p class="mb-xxs"><?php echo e($descriptionBlock); ?></p>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<?php if($endpoint['body_params'] ?? false): ?>
    <details class="mb-m">
        <summary class="text-muted"><?php echo e($endpoint['method'] === 'GET' ? 'Query' : 'Body'); ?> Parameters</summary>
        <table class="table">
            <tr>
                <th>Param Name</th>
                <th>Value Rules</th>
            </tr>
            <?php $__currentLoopData = $endpoint['body_params']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paramName => $rules): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($paramName); ?></td>
                    <td>
                        <?php $__currentLoopData = $rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <code class="mr-xs"><?php echo e($rule); ?></code>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>
    </details>
<?php endif; ?>

<?php if($endpoint['example_request'] ?? false): ?>
    <details component="details-highlighter" class="mb-m">
        <summary class="text-muted">Example Request</summary>
        <pre><code class="language-json"><?php echo e($endpoint['example_request']); ?></code></pre>
    </details>
<?php endif; ?>

<?php if($endpoint['example_response'] ?? false): ?>
    <details component="details-highlighter" class="mb-m">
        <summary class="text-muted">Example Response</summary>
        <pre><code class="language-json"><?php echo e($endpoint['example_response']); ?></code></pre>
    </details>
<?php endif; ?>

<?php if(!$loop->last): ?>
    <hr>
<?php endif; ?><?php /**PATH /var/www/sacredwits.com/resources/views/api-docs/parts/endpoint.blade.php ENDPATH**/ ?>