<?php $__env->startSection('body'); ?>

    <div class="container">

        <div class="my-s">
            <?php echo $__env->make('entities.breadcrumbs', ['crumbs' => [
                $book,
                $book->getUrl('/sort') => [
                    'text' => trans('entities.books_sort'),
                    'icon' => 'sort',
                ]
            ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <div class="grid left-focus gap-xl">
            <div>
                <div component="book-sort" class="card content-wrap auto-height">
                    <h1 class="list-heading"><?php echo e(trans('entities.books_sort')); ?></h1>
                    <p class="text-muted"><?php echo e(trans('entities.books_sort_desc')); ?></p>

                    <div refs="book-sort@sortContainer">
                        <?php echo $__env->make('books.parts.sort-box', ['book' => $book, 'bookChildren' => $bookChildren], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <form action="<?php echo e($book->getUrl('/sort')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="_method" value="PUT">
                        <input refs="book-sort@input" type="hidden" name="sort-tree">
                        <div class="list text-right">
                            <a href="<?php echo e($book->getUrl()); ?>" class="button outline"><?php echo e(trans('common.cancel')); ?></a>
                            <button class="button" type="submit"><?php echo e(trans('entities.books_sort_save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>

            <div>
                <main class="card content-wrap auto-height sticky-top-m">
                    <h2 class="list-heading"><?php echo e(trans('entities.books_sort_show_other')); ?></h2>
                    <p class="text-muted"><?php echo e(trans('entities.books_sort_show_other_desc')); ?></p>

                    <?php echo $__env->make('entities.selector', ['name' => 'books_list', 'selectorSize' => 'compact', 'entityTypes' => 'book', 'entityPermission' => 'update'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                </main>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.simple', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sacredwits.com/resources/views/books/sort.blade.php ENDPATH**/ ?>