<?php

namespace Tests\Commands;

use BookStack\Activity\ActivityType;
use BookStack\Facades\Activity;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Tests\TestCase;

class ClearActivityCommandTest extends TestCase
{
    public function test_clear_activity_command()
    {
        $this->asEditor();
        $page = $this->entities->page();
        Activity::add(ActivityType::PAGE_UPDATE, $page);

        $this->assertDatabaseHas('activities', [
            'type'      => 'page_update',
            'loggable_id' => $page->id,
            'user_id'   => $this->users->editor()->id,
        ]);

        DB::rollBack();
        $exitCode = Artisan::call('bookstack:clear-activity');
        DB::beginTransaction();
        $this->assertTrue($exitCode === 0, 'Command executed successfully');

        $this->assertDatabaseMissing('activities', [
            'type' => 'page_update',
        ]);
    }
}
